#pragma once

#include <src/logic/interface/sync_organizations.hpp>
#include <src/services/db/events_queue/query.hpp>
#include <src/services/db/execute.hpp>
#include <src/services/directory/directory_client_impl.hpp>

#include <boost/range/algorithm/transform.hpp>

namespace collie::logic::db {

template <class MakeEventsQueueConnectionProvider>
class SyncOrganizationsImpl final : public SyncOrganizations {
public:
    SyncOrganizationsImpl(
        MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider,
        const services::directory::DirectoryClientPtr& directoryClient
    )
        : makeEventsQueueConnectionProvider(std::move(makeEventsQueueConnectionProvider))
        , directoryClient(directoryClient) {
    }

    virtual expected<void> operator()(const TaskContextPtr& context) const override {
        auto getOrgResult = directoryClient->getOrganizations(context);
        if (!getOrgResult) {
            return make_unexpected(getOrgResult.error());
        }
        LOGDOG_(context->logger(), notice, log::message="add org_ids size=" + std::to_string(getOrgResult.value().size()));
        auto& organizations = getOrgResult.value();

        const auto chunkSize {10000};
        auto result = expected<void>();
        services::db::events_queue::query::AddDirectoryEventForUsers query;
        for (std::size_t index{0}; index < organizations.size(); ++index) {
            query.user_ids.emplace_back(services::db::OrgUserId{organizations[index].id});
            if ((query.user_ids.size() == chunkSize) || (index == (organizations.size() - 1))) {
                result = execute(makeEventsQueueConnectionProvider(context), std::as_const(query));
                if (!result) {
                    return result;
                }
                query.user_ids.clear();
            }
        }
        return result;
    }

private:
    MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider;
    services::directory::DirectoryClientPtr directoryClient;
};

} // namespace collie::logic::db
