#include "utils.hpp"

namespace collie::logic::db {

bool convertToNonnegativeNumber(const RequestLogger& logger, const std::optional<std::string_view>& original,
        std::optional<std::int64_t>& converted, const std::string& name) {
    if (original) {
        auto number{0ll};
        const std::string originalValue{*original};
        if (!boost::conversion::try_lexical_convert<decltype(number)>(originalValue, number)) {
            LOGDOG_(logger, error, log::message = "invalid " + name + " (" + originalValue + ")");
            return false;
        }

        if (number < 0) {
            LOGDOG_(logger, error, log::message = name + " (" + originalValue + ") must not be negative");
            return false;
        }

        converted = number;
    }

    return true;
}

}
