#pragma once

#include "types/carddav_multiget_result.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct CarddavMultiget {
    virtual ~CarddavMultiget() = default;

    virtual expected<CarddavMultigetResult> operator()(const TaskContextPtr& context, const Uid& uid,
            std::vector<std::string> uris) const = 0;
};

} // namespace collie::logic
