#pragma once

#include "types/carddav_propfind_result.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct CarddavPropfind {
    virtual ~CarddavPropfind() = default;

    virtual expected<CarddavPropfindResult> operator()(const TaskContextPtr& context,
            const Uid& uid) const = 0;
};

} // namespace collie::logic
