#pragma once

#include "types/carddav_put_result.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct CarddavPut {
    virtual ~CarddavPut() = default;

    virtual expected<CarddavPutResult> operator()(const TaskContextPtr& context, const Uid& uid,
            const std::string& uri, const std::string& etag, std::string vcard) const = 0;
};

} // namespace collie::logic
