#pragma once

#include "types/created_contacts.hpp"
#include "types/new_contact.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

#include <vector>

namespace collie::logic {

struct CreateContacts {
    virtual ~CreateContacts() = default;

    virtual expected<CreatedContacts> operator ()(const TaskContextPtr& context, const Uid& uid,
            std::vector<NewContact> newContacts) const = 0;
};

} // namespace collie::logic
