#pragma once

#include "types/created_tag.hpp"
#include "types/new_tag.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct CreateTag {
    virtual ~CreateTag() = default;

    virtual expected<CreatedTag> operator()(const TaskContextPtr& context, const Uid& uid,
            const NewTag& tag) const = 0;
};

} // namespace collie::logic
