#pragma once

#include "types/uid.hpp"

#include <src/services/abook/types/reflection/search_contacts_result.hpp>
#include <src/error_code.hpp>
#include <src/expected.hpp>
#include <src/task_context.hpp>

#include <vector>

namespace collie::logic {

struct GetAbookFormatContacts {
    virtual ~GetAbookFormatContacts() = default;

    virtual expected<services::abook::SearchContactsResult> operator()(
            const TaskContextPtr& context,
            const Uid& uid,
            const std::optional<std::string_view>& mixin,
            const std::optional<std::string_view>& group) const = 0;
};

} // namespace collie::logic
