#pragma once

#include "types/existing_contacts.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct GetContacts {
    virtual ~GetContacts() = default;

    virtual expected<ExistingContacts> operator()(
            const TaskContextPtr& context,
            const Uid& uid,
            const std::vector<ContactId>& contactIds,
            const std::optional<std::string_view>& mixin,
            const std::optional<std::string_view>& offset,
            const std::optional<std::string_view>& limit,
            bool onlyShared,
            bool sharedWithEmails) const = 0;
};

} // namespace collie::logic
