#pragma once

#include "types/uid.hpp"
#include "types/contacts_counters_result.hpp"

#include <src/error_code.hpp>
#include <src/expected.hpp>
#include <src/task_context.hpp>

#include <vector>

namespace collie::logic {

struct GetContactsCount {
    virtual ~GetContactsCount() = default;

    virtual auto operator ()(
        const TaskContextPtr& context,
        const Uid& uid,
        const std::optional<std::string_view>& mixin,
        bool sharedWithEmails) const
            -> decltype(expected<ContactsCountersResult>()) = 0;
};

} // namespace collie::logic
