#pragma once

#include "types/existing_contacts.hpp"
#include "types/tag_id.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct GetContactsWithTag {
    virtual ~GetContactsWithTag() = default;

    virtual expected<ExistingContacts> operator()(
            const TaskContextPtr& context,
            const Uid& uid,
            TagId tagId,
            const std::optional<std::string_view>& offset,
            const std::optional<std::string_view>& limit) const = 0;
};

} // namespace collie::logic
