#pragma once

#include "types/get_emails_result.hpp"
#include "types/tag_id.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct GetEmails {
    virtual ~GetEmails() = default;

    virtual expected<GetEmailsResult> operator()(
            const TaskContextPtr& context,
            const Uid& uid,
            const std::vector<TagId>& tagIds,
            const std::optional<std::string_view>& mixin) const = 0;
};

} // namespace collie::logic
