#pragma once

#include "types/uid.hpp"
#include "types/list_id.hpp"
#include "types/list_contacts_counter.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct GetSharedContactsCountFromList {
    virtual ~GetSharedContactsCountFromList() = default;

    virtual expected<ListContactsCounter> operator()(const TaskContextPtr& context, const Uid& uid,
            ListId listId, bool sharedWithEmails) const = 0;
};

} // namespace collie::logic
