#pragma once

#include "types/existing_contacts.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct GetSharedContactsFromList {
    virtual ~GetSharedContactsFromList() = default;

    virtual expected<ExistingContacts> operator()(
            const TaskContextPtr& context,
            const Uid& uid,
            const std::vector<ContactId>& contactIds,
            ListId listId,
            const std::optional<std::string_view>& offset,
            const std::optional<std::string_view>& limit,
            bool sharedWithEmails) const = 0;
};

} // namespace collie::logic
