#pragma once

#include "types/contact_id.hpp"
#include "types/revision.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

#include <vector>

namespace collie::logic {

struct RemoveContacts {
    virtual ~RemoveContacts() = default;

    virtual expected<Revision> operator()(const TaskContextPtr& context, const Uid& uid,
            const std::vector<ContactId>& contactIds) const = 0;
};

} // namespace collie::logic
