#pragma once

#include "types/revision.hpp"
#include "types/tag_id.hpp"
#include "types/uid.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct RemoveTag {
    virtual ~RemoveTag() = default;

    virtual expected<Revision> operator()(const TaskContextPtr& context, const Uid& uid,
            const TagId tagId) const = 0;
};

} // namespace collie::logic
