#pragma once

#include "revision.hpp"

#include <ctime>
#include <string>

namespace collie::logic {

enum class ChangeType {
    abook,
    createUser,
    deleteUser,
    createList,
    deleteList,
    updateList,
    shareList,
    revokeList,
    createContacts,
    deleteContacts,
    updateContacts,
    createTag,
    deleteTag,
    updateTag,
    tagContacts,
    untagContacts,
    createEmails,
    deleteEmails,
    updateEmails,
    tagEmails,
    untagEmails,
    copyAbook,
    createDirectoryEntities,
    deleteDirectoryEntities,
    subscribeToList,
    revokeSubscribedList
};

struct Change {
    Revision revision;
    std::time_t time;
    ChangeType type;
};

} // namespace collie::logic
