#pragma once

#include "directory_entity_type.hpp"
#include "directory_entity_id.hpp"

namespace collie::logic {

struct DirectoryEntityIdAndType {
    DirectoryEntityId id;
    DirectoryEntityType type;
};

inline bool operator <(const DirectoryEntityIdAndType& lhs, const DirectoryEntityIdAndType& rhs) {
    return std::tie(lhs.id, lhs.type) < std::tie(rhs.id, rhs.type);
}

} // namespace collie::logic
