#pragma once

#include <map>
#include <string_view>

namespace collie::logic {

enum DirectoryEntityType {
    department,
    group,
    user
};

inline DirectoryEntityType makeDirectoryEntityType(std::string_view value) {
    static const std::map<std::string_view, DirectoryEntityType> types {
        {"department", DirectoryEntityType::department},
        {"group", DirectoryEntityType::group},
        {"user", DirectoryEntityType::user},
    };
    return types.at(value);
}

inline std::string toString(DirectoryEntityType value) {
    switch (value) {
        case DirectoryEntityType::department:
            return "department";
        case DirectoryEntityType::group:
            return "group";
        case DirectoryEntityType::user:
            return "user";
    }
    return "unknown";
}

} // namespace collie::logic
