#include "change.hpp"

#include <map>

namespace collie::logic {

std::string toString(const ChangeType value) {
    switch (value) {
        case ChangeType::abook:
            return "abook";
        case ChangeType::createUser:
            return "create_user";
        case ChangeType::deleteUser:
            return "delete_user";
        case ChangeType::createList:
            return "create_list";
        case ChangeType::deleteList:
            return "delete_list";
        case ChangeType::updateList:
            return "update_list";
        case ChangeType::shareList:
            return "share_list";
        case ChangeType::revokeList:
            return "revoke_list";
        case ChangeType::createContacts:
            return "create_contacts";
        case ChangeType::deleteContacts:
            return "delete_contacts";
        case ChangeType::updateContacts:
            return "update_contacts";
        case ChangeType::createTag:
            return "create_tag";
        case ChangeType::deleteTag:
            return "delete_tag";
        case ChangeType::updateTag:
            return "update_tag";
        case ChangeType::tagContacts:
            return "tag_contacts";
        case ChangeType::untagContacts:
            return "untag_contacts";
        case ChangeType::createEmails:
            return "create_emails";
        case ChangeType::deleteEmails:
            return "delete_emails";
        case ChangeType::updateEmails:
            return "update_emails";
        case ChangeType::tagEmails:
            return "tag_emails";
        case ChangeType::untagEmails:
            return "untag_emails";
        case ChangeType::copyAbook:
            return "copy_abook";
        case ChangeType::createDirectoryEntities:
            return "create_directory_entities";
        case ChangeType::deleteDirectoryEntities:
            return "delete_directory_entities";
        case ChangeType::subscribeToList:
            return "subscribe_to_list";
        case ChangeType::revokeSubscribedList:
            return "revoke_subscribed_list";
    }
    return "collie::logic::ChangeType::" + std::to_string(static_cast<unsigned>(value));
}

ChangeType makeChangeType(std::string_view type) {
    static std::map<std::string_view, ChangeType> types {
        {"abook", ChangeType::abook},
        {"create_user", ChangeType::createUser},
        {"delete_user", ChangeType::deleteUser},
        {"create_list", ChangeType::createList},
        {"delete_list", ChangeType::deleteList},
        {"update_list", ChangeType::updateList},
        {"share_list", ChangeType::shareList},
        {"revoke_list", ChangeType::revokeList},
        {"create_contacts", ChangeType::createContacts},
        {"delete_contacts", ChangeType::deleteContacts},
        {"update_contacts", ChangeType::updateContacts},
        {"create_tag", ChangeType::createTag},
        {"delete_tag", ChangeType::deleteTag},
        {"update_tag", ChangeType::updateTag},
        {"tag_contacts", ChangeType::tagContacts},
        {"untag_contacts", ChangeType::untagContacts},
        {"create_emails", ChangeType::createEmails},
        {"delete_emails", ChangeType::deleteEmails},
        {"update_emails", ChangeType::updateEmails},
        {"tag_emails", ChangeType::tagEmails},
        {"untag_emails", ChangeType::untagEmails},
        {"copy_abook", ChangeType::copyAbook},
        {"create_directory_entities", ChangeType::createDirectoryEntities},
        {"delete_directory_entities", ChangeType::deleteDirectoryEntities},
        {"subscribe_to_list", ChangeType::subscribeToList},
        {"revoke_subscribed_list", ChangeType::revokeSubscribedList}
    };

    return types.at(type);
}

} // collie::logic
