#include "contacts_location.hpp"

#include <map>

namespace collie::logic {

std::string toString(const ContactsLocationType value) {
    static std::map<ContactsLocationType, std::string> types {
        {ContactsLocationType::abookDb, "abookdb"},
        {ContactsLocationType::contactsDb, "contactsdb"}
    };

    return types.at(value);
}

ContactsLocationType makeContactsLocationType(std::string_view value) {
    static std::map<std::string_view, ContactsLocationType> types {
        {"abookdb", ContactsLocationType::abookDb},
        {"contactsdb", ContactsLocationType::contactsDb}
    };

    return types.at(value);
}

} // collie::logic
