#include "existing_tag.hpp"

namespace collie::logic {

std::string toString(TagType value) {
    switch (value) {
        case TagType::user:
            return "user";
        case TagType::system:
            return "system";
    }
    return "collie::logic::TagType::" + std::to_string(static_cast<unsigned>(value));
}

TagType makeTagType(std::string_view type) {
    static std::map<std::string_view, TagType> types {
            {"user", TagType::user},
            {"system", TagType::system}
    };

    return types.at(type);
}

} // collie::logic
