#include "new_event.hpp"

namespace collie::logic {

std::string toString(const EventType value) {
    switch (value) {    
        case EventType::updateOrg:
            return "organization_updated";
        case EventType::deleteOrg:
            return "organization_deleted";
    }

    return "collie::logic::EventType::" + std::to_string(static_cast<unsigned>(value));
}

EventType makeEventType(std::string_view type) {
    if (type == "organization_deleted") {
        return EventType::deleteOrg;
    }
    
    return EventType::updateOrg;
}

} // collie::logic
