#pragma once

#include <src/logic/interface/types/existing_contact.hpp>

#include <boost/fusion/adapted/struct/adapt_struct.hpp>

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Name,
    prefix,
    first,
    middle,
    last,
    suffix
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Email,
    email,
    type,
    label
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::InstantMessenger,
    protocol,
    type,
    service_id,
    service_type
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::SocialProfile,
    profile,
    type,
    label
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::TelephoneNumber,
    telephone_number,
    additional,
    type,
    label
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::DirectoryEntry,
    org_id,
    org_name,
    entry_id,
    type
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Event,
    year,
    month,
    day,
    label,
    type
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Photo,
    uri,
    storage,
    type
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Address,
    extended,
    post_office_box,
    street,
    city,
    region,
    postal_code,
    country,
    label,
    type
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Organization,
    company,
    title,
    summary,
    department,
    type
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Website,
    url,
    type,
    label
)

BOOST_FUSION_ADAPT_STRUCT(collie::logic::Vcard,
    names,
    emails,
    instant_messengers,
    social_profiles,
    telephone_numbers,
    vcard_uids,
    directory_entries,
    notes,
    description,
    events,
    photos,
    addresses,
    organizations,
    nicknames,
    websites,
    tzs
)
