#pragma once

#include <cstdint>
#include <optional>
#include <string>
#include <vector>

namespace collie::logic {

struct Name {
    std::optional<std::string> first;
    std::optional<std::string> middle;
    std::optional<std::string> last;
    std::optional<std::string> suffix;
    std::optional<std::string> prefix;
};

inline bool operator==(const Name& left, const Name& right) {
    return std::tie(left.first, left.middle, left.last, left.suffix, left.prefix) ==
        std::tie(right.first, right.middle, right.last, right.suffix, right.prefix);
}

struct Email {
    std::optional<std::string> email;
    std::optional<std::vector<std::string>> type;
    std::optional<std::string> label;
};

inline bool operator==(const Email& left, const Email& right) {
    return std::tie(left.email) == std::tie(right.email);
}

struct InstantMessenger {
    std::optional<std::string> protocol;
    std::optional<std::vector<std::string>> type;
    std::optional<std::string> service_id;
    std::optional<std::string> service_type;
};

struct SocialProfile {
    std::optional<std::string> profile;
    std::optional<std::vector<std::string>> type;
    std::optional<std::string> label;
};

struct TelephoneNumber {
    std::optional<std::string> telephone_number;
    std::optional<std::string> additional;
    std::optional<std::vector<std::string>> type;
    std::optional<std::string> label;
};

struct DirectoryEntry {
    std::optional<std::int64_t> org_id;
    std::optional<std::string> org_name;
    std::optional<std::int64_t> entry_id;
    std::optional<std::vector<std::string>> type;
};

struct Event {
    std::optional<std::int64_t> year;
    std::optional<std::int64_t> month;
    std::optional<std::int64_t> day;
    std::optional<std::string> label;
    std::optional<std::vector<std::string>> type;
};

struct Photo {
    std::optional<std::string> uri;
    std::optional<std::string> storage;
    std::optional<std::vector<std::string>> type;
};

struct Address {
    std::optional<std::string> extended;
    std::optional<std::string> post_office_box;
    std::optional<std::string> street;
    std::optional<std::string> city;
    std::optional<std::string> region;
    std::optional<std::string> postal_code;
    std::optional<std::string> country;
    std::optional<std::string> label;
    std::optional<std::vector<std::string>> type;
};

struct Organization {
    std::optional<std::string> company;
    std::optional<std::string> title;
    std::optional<std::string> summary;
    std::optional<std::string> department;
    std::optional<std::vector<std::string>> type;
};

struct Website {
    std::optional<std::string> url;
    std::optional<std::vector<std::string>> type;
    std::optional<std::string> label;
};

struct Vcard {
    std::optional<std::vector<Name>> names;
    std::optional<std::vector<Email>> emails;
    std::optional<std::vector<InstantMessenger>> instant_messengers;
    std::optional<std::vector<SocialProfile>> social_profiles;
    std::optional<std::vector<TelephoneNumber>> telephone_numbers;
    std::optional<std::vector<std::string>> vcard_uids;
    std::optional<std::vector<DirectoryEntry>> directory_entries;
    std::optional<std::vector<std::string>> notes;
    std::optional<std::string> description;
    std::optional<std::vector<Event>> events;
    std::optional<std::vector<Photo>> photos;
    std::optional<std::vector<Address>> addresses;
    std::optional<std::vector<Organization>> organizations;
    std::optional<std::vector<std::string>> nicknames;
    std::optional<std::vector<Website>> websites;
    std::optional<std::vector<std::string>> tzs;
};

} // namespace collie::logic
