#pragma once

#include "types/revision.hpp"
#include "types/uid.hpp"
#include "types/updated_contacts.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

#include <vector>

namespace collie::logic {

struct UpdateContacts {
    virtual ~UpdateContacts() = default;

    virtual expected<Revision> operator ()(const TaskContextPtr& context, const Uid& uid,
            UpdatedContacts updatedContacts) const = 0;
};

} // namespace collie::logic
