#pragma once

#include "types/revision.hpp"
#include "types/tag_id.hpp"
#include "types/uid.hpp"
#include "types/updated_tag.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::logic {

struct UpdateTag {
    virtual ~UpdateTag() = default;

    virtual expected<Revision> operator()(const TaskContextPtr& context, const Uid& uid, const TagId tagId,
            const UpdatedTag& updatedTag) const = 0;
};

} // namespace collie::logic
