#pragma once

#include <src/logic/interface/types/get_emails_result.hpp>

#include <boost/range/adaptor/transformed.hpp>
#include <boost/range/algorithm/copy.hpp>

namespace collie::logic {

template<typename Map> GetEmailsResult makeGetEmailsResult(Map&& mappedEmails) {
    const auto transformer{[&](auto& tagWithEmails){return ExistingEmails{tagWithEmails.first,
            static_cast<std::int64_t>(tagWithEmails.second.size()), std::move(tagWithEmails.second)};}};
    const auto transformedEmails{mappedEmails | boost::adaptors::transformed(std::move(transformer))};
    GetEmailsResult result;
    boost::copy(transformedEmails, std::back_inserter(result.emails));
    return result;
}

} // namespace collie::logic
