#include "module.hpp"
#include "api.hpp"
#include "config.hpp"
#include "config_reflection.hpp"
#include "server/server.hpp"

#include <yplatform/module_registration.h>

#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>

#include <yamail/data/deserialization/ptree.h>

#include <pa/async.h>

namespace collie {

void Module::init(const yplatform::ptree& data) {
    using yamail::data::deserialization::fromPtree;
    using TvmGuard = tvm_guard::Guard<ymod_tvm::tvm2_module>;

    const auto config = fromPtree<Config>(data);
    if (!pa::async_profiler::is_init()) {
        pa::async_profiler::init(1000000, 16000, config.profilerLogName);
    }

    auto api = makeApi(
        config,
        std::make_shared<const TvmGuard>(
            tvm_guard::init(
                data.get_child("tvm_guard"),
                yplatform::find<ymod_tvm::tvm2_module, std::shared_ptr>(config.tvmModule)
            )
        )
    );
    struct Api : decltype(api) {};
    server::init(config.server, Api {std::move(api)});
}

} // namespace collie

DEFINE_SERVICE_OBJECT(collie::Module)
