#pragma once

#include "error.hpp"

#include <src/error_code.hpp>

namespace boost::system {

template <>
struct is_error_code_enum<collie::server::Error> : std::true_type {};

} // namespace boost::system

namespace collie::server {

class ErrorCategory final : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "collie::server::ErrorCategory";
    }

    std::string message(int value) const override {
        switch (static_cast<Error>(value)) {
            case Error::ok:
                return "ok";
            case Error::routeError:
                return "route error";
            case Error::unclassifiedError:
                return "unclassified error";
            case Error::notImplemented:
                return "not implemented";
            case Error::invalidParameter:
                return "invalid parameter";
            case Error::invalidRequestBodyFormat:
                return "invalid request body format";
            case Error::invalidRequestBodyContent:
                return "invalid request body content";
            case Error::invalidTvm2Ticket:
                return "invalid TVM2 ticket";
        }
        return "unknown error code: " + std::to_string(value);
    }

    static const ErrorCategory& instance() {
        static const ErrorCategory errorCategory;
        return errorCategory;
    }
};

inline error_code::base_type make_error_code(Error ec) {
    return error_code::base_type(static_cast<int>(ec), ErrorCategory::instance());
}

} // namespace collie::server
