#include "abook_search_contacts_handler.hpp"

#include <src/log.hpp>
#include <src/services/abook/types/reflection/search_contacts_result.hpp>
#include <src/server/respond.hpp>
#include <src/server/utils.hpp>

namespace collie::server {

AbookSearchContactsHandler::AbookSearchContactsHandler(const std::shared_ptr<const logic::GetAbookFormatContacts>& impl)
    : impl(impl) {}

expected<void> AbookSearchContactsHandler::operator()(const StreamPtr& stream,
        const TaskContextPtr& context) const
{
    const auto& request = stream->request();
    const auto& params = request->url.params;
    const auto uid{getOrNone(params, "uid")};
    if (!uid) {
        LOGDOG_(context->logger(), error, log::message=R"("uid" not present in query string)");
        return make_unexpected(error_code(Error::invalidParameter));
    }

    const auto mixin{getOrNone(params, "mixin")};
    const auto group{getOrNone(params, "group")};
    return ((*impl)(context, std::string(*uid), mixin, group)).bind([&](auto&& result) {
        return std::visit([&](auto&& value){return respondWithJson(stream, make_expected(std::move(value)));},
                std::move(result));
    });
}

} // namespace collie::server
