#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_abook_format_contacts.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class AbookSearchContactsHandler {
public:
    AbookSearchContactsHandler(const std::shared_ptr<const logic::GetAbookFormatContacts>& impl);

    expected<void> operator()(const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetAbookFormatContacts> impl;
};

} // namespace collie::server
