#include "add_directory_event_handler.hpp"

#include <src/logic/interface/types/reflection/new_event.hpp>
#include <src/server/parse_request_body.hpp>
#include <src/server/respond.hpp>

namespace collie::server {

AddDirectoryEventHandler::AddDirectoryEventHandler(
        const std::shared_ptr<const logic::AddDirectoryEvent>& impl)
    : impl(impl) {
}

expected<void> AddDirectoryEventHandler::operator()(const StreamPtr& stream,
        const TaskContextPtr& context) const {
    const auto request(stream->request());
    const std::string body(request->raw_body.begin(), request->raw_body.end());

    return parseRequestBody<logic::NewEvent>(body, context->logger(), "failed to parse new event"_s)
        .bind([&] (auto&& newEvent) {
            return respondWithJson(stream, (*impl)(context, std::move(newEvent)));
        });
}

} // namespace collie::server
