#include "add_emails_handler.hpp"

#include <src/logic/interface/types/reflection/created_contacts.hpp>
#include <src/logic/interface/types/reflection/recipients.hpp>
#include <src/log.hpp>

#include <src/server/parse_request_body.hpp>
#include <src/server/respond.hpp>

namespace collie::server {

AddEmailsHandler::AddEmailsHandler(const std::shared_ptr<const logic::AddEmails>& impl)
    : impl(impl) {
}

expected<void> AddEmailsHandler::operator()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    const auto& request = stream->request();
    const std::string body{request->raw_body.begin(), request->raw_body.end()};
    return parseRequestBody<logic::Recipients>(body, context->logger(), "failed to parse recipients"_s).
            bind([&](auto&& recipients) {
        return respondWithJson(stream, (*impl)(context, uid.value, std::move(recipients)));
    });
}

} // namespace collie::server
