#include "carddav_delete_handler.hpp"

#include <src/server/respond.hpp>

namespace collie::server {

CarddavDeleteHandler::CarddavDeleteHandler(const std::shared_ptr<const logic::CarddavDelete>& impl)
    : impl(impl) {
}

expected<void> CarddavDeleteHandler::operator()(const Uid& uid, const Uri& uri, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    return respond(stream, (*impl)(context, uid.value, uri.value));
}

} // namespace collie::server
