#pragma once

#include "parameters.hpp"

#include <src/logic/interface/carddav_delete.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class CarddavDeleteHandler {
public:
    explicit CarddavDeleteHandler(const std::shared_ptr<const logic::CarddavDelete>& impl);

    expected<void> operator()(const Uid& uid, const Uri& uri, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::CarddavDelete> impl;
};

} // namespace collie::server
