#pragma once

#include "parameters.hpp"

#include <src/logic/interface/carddav_multiget.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class CarddavMultigetHandler {
public:
    explicit CarddavMultigetHandler(const std::shared_ptr<const logic::CarddavMultiget>& impl);

    expected<void> operator()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::CarddavMultiget> impl;
};

} // namespace collie::server
