#include "carddav_propfind_handler.hpp"

#include <src/logic/interface/types/reflection/carddav_propfind_result.hpp>

#include <src/server/respond.hpp>

namespace collie::server {

CarddavPropfindHandler::CarddavPropfindHandler(const std::shared_ptr<const logic::CarddavPropfind>& impl)
    : impl(impl) {
}

expected<void> CarddavPropfindHandler::operator()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    const std::string rootTagName{"response"};
    return respondWithXml(stream, (*impl)(context, uid.value), rootTagName);
}

} // namespace collie::server
