#pragma once

#include "parameters.hpp"

#include <src/logic/interface/carddav_propfind.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class CarddavPropfindHandler {
public:
    explicit CarddavPropfindHandler(const std::shared_ptr<const logic::CarddavPropfind>& impl);

    expected<void> operator()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::CarddavPropfind> impl;
};

} // namespace collie::server
