#include "carddav_put_handler.hpp"

#include <src/logic/interface/types/reflection/carddav_put_result.hpp>
#include <src/server/respond.hpp>

namespace collie::server {

CarddavPutHandler::CarddavPutHandler(const std::shared_ptr<const logic::CarddavPut>& impl)
    : impl(impl) {
}

expected<void> CarddavPutHandler::operator()(const Uid& uid, const Uri& uri, const Etag& etag,
        const StreamPtr& stream, const TaskContextPtr& context) const {
    const auto& request = stream->request();
    std::string vcard{request->raw_body.begin(), request->raw_body.end()};
    const std::string rootTagName{"put-response"};
    return respondWithXml(stream, (*impl)(context, uid.value, uri.value, etag.value, std::move(vcard)),
            rootTagName);
}

} // namespace collie::server
