#pragma once

#include "parameters.hpp"

#include <src/logic/interface/carddav_put.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class CarddavPutHandler {
public:
    explicit CarddavPutHandler(const std::shared_ptr<const logic::CarddavPut>& impl);

    expected<void> operator()(const Uid& uid, const Uri& uri, const Etag& etag, const StreamPtr& stream,
            const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::CarddavPut> impl;
};

} // namespace collie::server
