#include "create_contacts_handler.hpp"

#include <src/logic/interface/types/reflection/created_contacts.hpp>
#include <src/logic/interface/types/reflection/new_contact.hpp>

#include <src/server/parse_request_body.hpp>
#include <src/server/respond.hpp>
#include <src/log.hpp>

namespace collie::server {

CreateContactsHandler::CreateContactsHandler(const std::shared_ptr<const logic::CreateContacts>& impl)
    : impl(impl) {}

expected<void> CreateContactsHandler::operator ()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    using namespace boost::hana::literals;

    const auto request = stream->request();
    const std::string body(request->raw_body.begin(), request->raw_body.end());

    return parseRequestBody<std::vector<logic::NewContact>>(body, context->logger(),
            "failed to parse new contacts"_s)
        .bind([&] (auto&& newContacts) {
            return respondWithJson(stream, (*impl)(context, uid.value, std::move(newContacts)));
        });
}

} // namespace collie::server
