#pragma once

#include "parameters.hpp"

#include <src/logic/interface/create_contacts.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class CreateContactsHandler {
public:
    CreateContactsHandler(const std::shared_ptr<const logic::CreateContacts>& impl);

    expected<void> operator ()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::CreateContacts> impl;
};

} // namespace collie::server
