#include "create_tag_handler.hpp"

#include <src/server/parse_request_body.hpp>
#include <src/server/respond.hpp>

#include <src/logic/interface/types/reflection/created_tag.hpp>
#include <src/logic/interface/types/reflection/new_tag.hpp>

#include <src/log.hpp>

namespace collie::server {

CreateTagHandler::CreateTagHandler(const std::shared_ptr<const logic::CreateTag>& impl)
    : impl(impl) {}

expected<void> CreateTagHandler::operator ()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    using yamail::data::deserialization::fromJson;

    const auto request = stream->request();
    const std::string body(request->raw_body.begin(), request->raw_body.end());

    return parseRequestBody<logic::NewTag>(body, context->logger(), "failed to parse new tag"_s)
        .bind([&] (auto&& newTag) { return respondWithJson(stream, (*impl)(context, uid.value, newTag)); });
}

} // namespace collie::server
