#pragma once

#include "parameters.hpp"

#include <src/logic/interface/create_tag.hpp>
#include <src/server/stream.hpp>

namespace collie::server {

class CreateTagHandler {
public:
    CreateTagHandler(const std::shared_ptr<const logic::CreateTag>& impl);

    expected<void> operator ()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::CreateTag> impl;
};

} // namespace collie::server
