#include "get_changes_handler.hpp"

#include <src/server/respond.hpp>

#include <src/logic/interface/types/reflection/changes.hpp>

namespace collie::server {

GetChangesHandler::GetChangesHandler(const std::shared_ptr<const logic::GetChanges>& impl)
    : impl(impl) {}

expected<void> GetChangesHandler::operator ()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    return respondWithJson(stream, (*impl)(context, uid.value));
}

} // namespace collie::server
