#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_changes.hpp>
#include <src/server/stream.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class GetChangesHandler {
public:
    GetChangesHandler(const std::shared_ptr<const logic::GetChanges>& impl);

    expected<void> operator ()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetChanges> impl;
};

} // namespace collie::server
