#include "get_contacts_count_handler.hpp"

#include <src/logic/interface/types/reflection/contacts_counters_result.hpp>

#include <src/server/respond.hpp>
#include <src/server/utils.hpp>

namespace collie::server {

GetContactsCountHandler::GetContactsCountHandler(const std::shared_ptr<const logic::GetContactsCount>& impl)
    : impl(impl) {}

expected<void> GetContactsCountHandler::operator ()(const Uid& uid, const StreamPtr& stream,
        const TaskContextPtr& context) const {
    const auto& request = stream->request();
    const auto& params = request->url.params;
    std::optional<std::string_view> mixin = getOrNone(params, "mixin");
    const auto sharedWithEmailsOpt = getOrNone(params, "shared_with_emails");
    bool sharedWithEmails = false;
    if (sharedWithEmailsOpt) {
        if (!mixin) {
            LOGDOG_(context->logger(), warning, log::message="missing mixin parameter for shared contacts with emails count request");
        }

        if (*sharedWithEmailsOpt == "1") {
            sharedWithEmails = true;
        }
    }
    return respondWithJson(stream, (*impl)(context, uid.value, mixin, sharedWithEmails));
}

} // namespace collie::server
