#pragma once

#include "parameters.hpp"

#include <src/logic/interface/get_contacts_count.hpp>
#include <src/server/stream.hpp>
#include <src/expected.hpp>
#include <src/error_code.hpp>

namespace collie::server {

class GetContactsCountHandler {
public:
    GetContactsCountHandler(const std::shared_ptr<const logic::GetContactsCount>& impl);

    expected<void> operator ()(const Uid& uid, const StreamPtr& stream, const TaskContextPtr& context) const;

private:
    std::shared_ptr<const logic::GetContactsCount> impl;
};

} // namespace collie::server
