#include "get_contacts_handler.hpp"

#include <src/server/respond.hpp>
#include <src/server/utils.hpp>

#include <src/logic/interface/types/reflection/existing_contacts.hpp>

namespace collie::server {

GetContactsHandler::GetContactsHandler(const std::shared_ptr<const logic::GetContacts>& impl)
    : impl(impl) {}

expected<void> GetContactsHandler::operator ()(const Uid& uid, const ContactIds& contactIds,
        const StreamPtr& stream, const TaskContextPtr& context) const {
    const auto& request = stream->request();
    const auto& params = request->url.params;
    std::optional<std::string_view> mixin = getOrNone(params, "mixin");
    std::optional<std::string_view> offset = getOrNone(params, "offset");
    std::optional<std::string_view> limit = getOrNone(params, "limit");
    const auto onlySharedOpt = getOrNone(params, "only_shared");
    const auto sharedWithEmailsOpt = getOrNone(params, "shared_with_emails");
    bool onlyShared = false;
    bool sharedWithEmails = false;
    if (onlySharedOpt) {
        if (!mixin) {
            LOGDOG_(context->logger(), warning, log::message="missing mixin param for get only shared contacts request");
        }

        if (*onlySharedOpt == "1") {
            onlyShared = true;
            if (sharedWithEmailsOpt && *sharedWithEmailsOpt == "1") {
                sharedWithEmails = true;
            }
        }
    }
    return respondWithJson(stream, (*impl)(
        context,
        uid.value,
        contactIds.value,
        mixin,
        offset,
        limit,
        onlyShared,
        sharedWithEmails));
}

} // namespace collie::server
